# Section AI for Science
[*Return*](https://github.com/SyncedAI00/Artificial-Intelligence-Terminology/blob/master/README.md)
索引编号|英文术语|中文翻译|常用缩写|来源&扩展|备注
---|---|---|---|---|---
AITD-00007|Accuracy|准确率||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00015|Activation Function|激活函数||[[1]](https://www.jiqizhixin.com/articles/2017-06-11-4)[[2]](https://www.jiqizhixin.com/articles/2017-06-18-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00016|Active Learning|主动学习||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-00056|Area Under ROC Curve|AUC（ROC曲线下方面积，度量分类模型好坏的标准）|AUC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00059|Artificial Intelligence|人工智能|AI|[[1]](https://www.jiqizhixin.com/articles/2017-05-21-4)[[2]](https://www.jiqizhixin.com/articles/2017-05-21-7)[[3]](https://www.jiqizhixin.com/articles/2017-05-17-16)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-00060|Artificial Neural Network|人工神经网络|ANN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-00069|Attention|注意力||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|机器学习|
AITD-00092|Back Propagation|反向传播|BP|[[1]](https://www.jiqizhixin.com/articles/2016-11-25-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-00100|Bagging|袋装| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-00108|Baseline|基准||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-00126|Bayesian Inference|贝叶斯推断||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|统计，机器学习|
AITD-00129|Bayesian Network|贝叶斯网/贝叶斯网络||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|Network翻译为网或网络皆可，只要统一翻译成网或者统一翻译成网络即可；统计，机器学习|
AITD-00139|Bernoulli Distribution|伯努利分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-00147|Bias|偏差/偏置||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|看上下语境；机器学习|
AITD-00153|Biased|有偏||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-00175|Boosting|Boosting（一种模型训练加速方式）||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00181|Bottom-Up|自下而上| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-00218|Classification|分类||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)||
AITD-00219|Classification And Regression Tree|分类与回归树|CART|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)||
AITD-00228|Cluster|簇||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00264|Computer Vision|计算机视觉| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-00285|Confusion Matrix|混淆矩阵||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-00289|Conjugate Gradient|共轭梯度| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|优化，数学|
AITD-00333|Correlation|相关系数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-00340|Cost Function|代价函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)||
AITD-00343|Covariance|协方差||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00344|Covariance Matrix|协方差矩阵||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00372|Data Augmentation|数据增强| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-00376|Data Mining|数据挖掘||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00380|Data Set|数据集||[[1]](https://www.jiqizhixin.com/articles/2018-01-04-6)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00389|Decision Tree|决策树|DT|[[1]](https://www.jiqizhixin.com/articles/2018-01-10)[[2]](https://www.jiqizhixin.com/articles/2017-11-29-5)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00402|Deep Learning|深度学习|DL|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-2)[[2]](https://www.jiqizhixin.com/articles/2018-01-15-4)[[3]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[5]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00405|Deep Neural Network|深度神经网络|DNN|[[1]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[2]](https://www.jiqizhixin.com/articles/2018-01-10)[[3]](https://www.jiqizhixin.com/articles/2018-01-07-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[7]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-00408|Deep Reinforcement Learning|深度强化学习| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-00445|Dimension Reduction|降维||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00446|Dimensionality Reduction Algorithm|降维算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[2]](https://www.jiqizhixin.com/articles/2017-08-31-2)| |
AITD-00532|Encoder-Decoder|编码器-解码器（模型）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-00559|Error Function|误差函数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-00565|Estimator|估计/估计量||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)||
AITD-00627|Feature Engineering|特征工程||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)||
AITD-00628|Feature Extraction|特征抽取| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-00633|Feature Selection|特征选择||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)||
AITD-00641|Feedforward Neural Network|前馈神经网络|FNN|[[1]](https://www.jiqizhixin.com/articles/2017-09-07-9)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)||
AITD-00706|Gaussian Distribution|高斯分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-00709|Gaussian Kernel Function|高斯核函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)||
AITD-00711|Gaussian Mixtures|高斯混合（模型）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-00713|Gaussian Process|高斯过程|GP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-00714|Gaussian Process Regression|高斯过程回归|GPR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-00737|Generative Modeling|生成式建模| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|机器学习|
AITD-00744|Genetic Algorithm|遗传算法|GA|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-3)[[2]](https://www.jiqizhixin.com/articles/2017-12-22)[[3]](https://www.jiqizhixin.com/articles/2017-11-12-2)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|机器学习|
AITD-00763|Gradient Descent|梯度下降||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-00788|Grid Search|网格搜索||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)||
AITD-00790|Ground Truth|真实值||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)||
AITD-00836|Hyperplane|超平面| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|数学|
AITD-00869|Inductive Bias|归纳偏好||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-00879|Information Gain|信息增益||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计|
AITD-00880|Information Gain Ratio|信息增益比| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计|
AITD-00916|Iteration|迭代| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|数学、机器学习|
AITD-00926|K-Fold Cross Validation|k 折交叉验证|K-FOLD CV|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-00927|K-Means Clustering|k-均值聚类| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://www.jiqizhixin.com/articles/2017-11-11-3)| |
AITD-00929|K-Nearest Neighbor Method|k-近邻|K-NN|[1]|统计|
AITD-00937|Kernel Method|核方法||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|机器学习|
AITD-00939|Kernel Trick|核技巧||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-00954|Label|标签/标记||[1]||
AITD-00984|Lazy Learning|懒惰学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-01019|Linear Combination|线性组合| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|数学|
AITD-01021|Linear Discriminant Analysis|线性判别分析|LDA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|统计、机器学习|
AITD-01024|Linear Model|线性模型|LR|[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|统计、机器学习|
AITD-01026|Linear Regression|线性回归||[[1]](https://www.jiqizhixin.com/articles/2018-01-01)[[2]](https://www.jiqizhixin.com/articles/2017-11-17-5)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计、数学|
AITD-01071|Logistic Function|对数几率函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)||
AITD-01073|Logistic Regression|对数几率回归|LR|[[1]](https://www.jiqizhixin.com/articles/2017-11-23-6)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|统计、机器学习|
AITD-01076|Long Short Term Memory|长短期记忆|LSTM|[[1]](https://www.jiqizhixin.com/articles/2017-12-18-6)[[2]](https://www.jiqizhixin.com/articles/2017-10-04-2)[[3]](https://www.jiqizhixin.com/articles/2017-09-29-7)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)||
AITD-01084|Loss Function|损失函数||[[1]](https://www.jiqizhixin.com/articles/2018-01-03-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-01088|Machine Learning|机器学习|ML|[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01103|Margin|间隔||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-01172|Meta-Learning|元学习| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-01175|Metric|指标| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-01209|Model Predictive Control|模型预测控制|MPC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-01210|Model Selection|模型选择||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-01241|Multi-Layer Perceptron|多层感知机|MLP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-01253|Multiple Linear Regression|多元线性回归|MLR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|统计|
AITD-01272|Natural Language Processing|自然语言处理|NLP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://www.nature.com/articles/s41557-021-00716-z)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[5]](https://www.jiqizhixin.com/articles/2017-12-14-5)[[6]](https://www.jiqizhixin.com/articles/2017-11-14-4)[[7]](https://www.jiqizhixin.com/articles/2017-11-12-3)|机器学习|
AITD-01299|Neural Model|神经模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-01300|Neural Network|神经网络|NN|[1]||
AITD-01308|Noise|噪声| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-01321|Non-Parametric|非参数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-01338|Normalization|规范化||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|统计、机器学习|
AITD-01358|Occam's Razor|奥卡姆剃刀||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-01365|One-Shot Learning|单试学习||[[1]](https://www.jiqizhixin.com/articles/2017-03-13-2)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-01380|Orthogonal|正交||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|数学|
AITD-01386|Outlier|异常点||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-01389|Output Layer|输出层| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-01395|Overfitting|过拟合||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-01412|Parameter Tuning|调参||[[1]](https://www.jiqizhixin.com/articles/2018-01-03-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|机器学习|
AITD-01417|Parse Tree|解析树| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-01421|Particle Swarm Optimization|粒子群优化算法|PSO|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-01426|Pattern Recognition|模式识别|PR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)| |
AITD-01428|Perceptron|感知机||[[1]](https://www.jiqizhixin.com/articles/2018-01-15-2)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|机器学习|
AITD-01482|Precision|查准率/准确率||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|数学、HPC|
AITD-01489|Principal Component Analysis|主成分分析|PCA|[[1]](https://www.jiqizhixin.com/articles/2017-12-03-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)||
AITD-01492|Prior Knowledge|先验知识| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|统计|
AITD-01509|Probability Distribution|概率分布||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)|统计|
AITD-01535|Quantum Mechanics|量子力学| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|物理|
AITD-01541|Radial Basis Function|径向基函数|RBF|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-01545|Random Forest|随机森林|RF、RFS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[4]](https://www.nature.com/articles/s41557-021-00716-z)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|统计|
AITD-01547|Random Sampling|随机采样||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|统计|
AITD-01561|Recall|查全率/召回率||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)||
AITD-01563|Receiver Operating Characteristic|受试者工作特征|ROC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-01573|Rectified Linear Unit|修正线性单元/整流线性单元|ReLU|[[1]](https://www.jiqizhixin.com/articles/2017-10-21-4)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|CHAPTER 2|
AITD-01579|Recurrent Neural Network|循环神经网络|RNN|[[1]](https://www.jiqizhixin.com/articles/2018-01-13-4)[[2]](https://www.jiqizhixin.com/articles/2018-01-05-5)[[3]](https://www.jiqizhixin.com/articles/2017-12-21-15)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[5]](https://www.nature.com/articles/s41557-021-00716-z)[[6]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-01585|Regression|回归||[[1]](https://www.jiqizhixin.com/articles/2017-12-21-13)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://www.nature.com/articles/s41557-021-00716-z)|统计|
AITD-01588|Reinforcement Learning|强化学习|RL|[[1]](https://www.jiqizhixin.com/articles/2018-01-17-3)[[2]](https://www.jiqizhixin.com/articles/2017-12-28-6)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)|机器学习|
AITD-01598|Representation Learning|表示学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)||
AITD-01627|Robustness|稳健性||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|计算机、机器学习|
AITD-01689|Sequence-To-Sequence|序列到序列|Seq2Seq|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-01707|Sigmoid|Sigmoid（一种激活函数）||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|统计|
AITD-01719|Simulated Annealing|模拟退火||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|统计、机器学习|
AITD-01723|Singular|奇异的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-01743|Softmax Function|Softmax函数/软最大化函数||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)|统计、机器学习|
AITD-01763|Speech Recognition|语音识别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[4]](https://www.jiqizhixin.com/articles/2018-01-01-3)[[5]](https://www.jiqizhixin.com/articles/2017-12-04)[[6]](https://www.jiqizhixin.com/articles/2017-12-15)| |
AITD-01800|Statistical Learning|统计学习||[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)||
AITD-01852|Supervised Learning|监督学习||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|机器学习|
AITD-01856|Support Vector|支持向量||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计、机器学习|
AITD-01858|Support Vector Machine|支持向量机|SVM|[[1]](https://www.jiqizhixin.com/articles/2017-10-08)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|统计、机器学习|
AITD-01859|Support Vector Regression|支持向量回归|SVR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|统计、机器学习|
AITD-01896|Test Set|测试集||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|机器学习|
AITD-01898|Threshold|阈值||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|数学|
AITD-01913|Top-Down|自顶向下| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-01928|Training Sample|训练样本||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01929|Training Set|训练集||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-01930|Trajectory|轨迹| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-01935|Transfer Learning|迁移学习||[[1]](https://www.jiqizhixin.com/articles/2018-01-04-7)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-01954|True Negative|真负例|TN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|统计|
AITD-01955|True Positive|真正例|TP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|统计|
AITD-01956|True Positive Rate|真正例率|TPR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|统计|
AITD-01971|Underfitting|欠拟合||[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02012|Unsupervised Learning|无监督学习|UL|[[1]](https://www.jiqizhixin.com/articles/2017-11-17-5)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-02020|Validation Set|验证集||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-02030|Variance|方差||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-02033|Variational Autoencoder|变分自编码器|VAE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)||
AITD-02063|Weight|权重||[[1]](https://www.jiqizhixin.com/articles/2018-01-08-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)||
AITD-02077|Word Embedding|词嵌入||[[1]](https://www.jiqizhixin.com/articles/2017-11-20-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)||
AITD-02094|2D Qsar Models|二维定量构效关系模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|化学|
AITD-02095|3D Cartesian|三维笛卡尔（坐标）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|数学|
AITD-02096|3D Conformation|三维构象| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|化学、生化|
AITD-02097|3D Grids|三维（坐标）网格| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02098|3D Qsar Models|三维定量构效关系模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|化学|
AITD-02099|Aberration-Corrected|像差矫正| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|物理|
AITD-02100|Active Machine Learning|主动机器学习| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|机器学习|
AITD-02101|Adaptive Fuzzy Neural Network|自适应模糊神经网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|机器学习|
AITD-02102|Adaptive Sampling|自适应采样| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-02103|Admet Evaluation|毒性评估| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|化学|
AITD-02104|Alexnet|AlexNet| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|机器学习|
AITD-02105|Alphago|阿尔法狗| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)|机器学习|
AITD-02106|Adaptive Neuro Fuzzy Inference System|自适应神经模糊推理系统| ANFIS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)|机器学习|
AITD-02107|Approximate Probabilistic Models|近似概率模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|机器学习|
AITD-02108|Artificial Neurons|人工神经元| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02109|Artificial Synapses|人工突触| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02110|Attention-Based|基于注意力（机制）的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-02111|Automating Synthetic Planning|自动化综合规划| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|机器学习|
AITD-02112|Automation|自动化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|机器学习|
AITD-02113|Autonomous Decision-Making|自主决策| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|机器学习|
AITD-02114|B-Clustering Algorithms|B树聚类算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|机器学习|
AITD-02115|Balanced Accuracy|平衡精度| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02116|Bandgap Energy|带隙能量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|物理|
AITD-02117|Baseline Test|基准测试| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02118|Basin Hopping|盆地跳跃（算法）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|机器学习|
AITD-02119|Bayesian Approach|贝叶斯方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)|统计，机器学习|
AITD-02120|Bayesian Induction|贝叶斯归纳| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|统计，机器学习|
AITD-02121|Bayesian Mcmc Methods|贝叶斯马尔可夫链蒙特卡洛方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)|统计，机器学习|
AITD-02122|Bayesian Methods|贝叶斯方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|统计，机器学习|
AITD-02123|Bayesian Molecular|贝叶斯分子（设计方法）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|统计，机器学习，化学|
AITD-02124|Bayesian Prior|贝叶斯先验| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|统计，机器学习|
AITD-02125|Bayesian Program Learning|贝叶斯程序学习|BPL|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计，机器学习|
AITD-02126|Bayesian Regularized Neural Network|贝叶斯正则化神经网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)|统计，机器学习|
AITD-02127|Beam-Scanning|波束扫描| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)|物理|
AITD-02128|Best Separates|最优分离| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-02129|Biased Dataset|有偏数据集| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02130|Bit Collisions|字节碰撞/冲突| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)|数据库|
AITD-02131|Black Box|黑盒子| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02132|Black-Box Attack|黑盒攻击| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02133|Bonding Environments|成键环境| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02134|Bonferroni Correction|邦弗朗尼校正| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-02135|Bootstrap Aggregation|引导聚合|bagging|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|机器学习|
AITD-02136|Broyden–Fletcher–Goldfarb–Shanno|BFGS（算法）|BFGS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|一种拟牛顿法，数学计算|
AITD-02137|Buchwald−Hartwig Cross-Coupling|Buchwald–Hartwig 偶联（反应）| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|化学|
AITD-02138|C4.5 Algorithm|C4.5 算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|一种决策树算法，数据挖掘|
AITD-02139|Calculation Uncertainties|计算不确定性| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02140|Canonical Ml Methods|经典机器学习方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02141|Cartesian Distance Vector|笛卡尔距离向量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)| |
AITD-02142|CASP|国际蛋白质结构预测竞赛| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|生物|
AITD-02143|Categorical Data|分类数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02144|Categorization Algorithms|分类算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02145|ChemDataExtractor|化学数据提取器|CDE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02146|Chi-Squared|卡方（分布）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02147|Classification Model|分类模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02148|Cluster Resolution Feature Selection|聚类分辨率特征选择|CR-FS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02149|Cluster-Based Splitting|基于聚类的分离方法| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02150|Clustering Methods|聚类方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02151|Code Pipeline|代码流水线| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02152|Coefficient of Determination|决定系数|r^2 or R^2|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计|
AITD-02153|Combined Gradient|组合梯度（算法）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-02154|Complex Data|复合数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02155|Computational Cost|计算成本| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02156|Computational Optimisation|计算优化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02157|Computational Science|计算科学| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02158|Computational Toxicology|计算毒理学| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02159|Computer Science|计算机科学| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02160|Computer Simulations|计算机模拟| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00512/978-1-78801-789-3)| |
AITD-02161|Computer-Aided|计算机辅助| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02162|Constraint|约束| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02163|Core-Loss Spectrum|（电子能量损失谱中的）高能区域| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02164|Coulomb Matrix|库仑矩阵| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02165|Coupled-Cluster Predictions|耦合簇预测| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02166|Cross-Validated Coefficient of Determination|交叉验证的决定系数|q^2 or Q^2|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02167|Cross-Validation|交叉验证|CV|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02168|Crowd-Sourcing|众包| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| 商业模式|
AITD-02169|Cut-Points|切点| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02170|Cutoff Radial Function|截断径向函数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)| |
AITD-02171|Data Availability|数据可用性| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02172|Data Cleaning|数据清洗| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02173|Data Collection|数据采集| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02174|Data Considerations|数据注意事项| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02175|Data Curation|数据监管| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02176|Data Disparity|数据差异| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02177|Data Dredging|数据挖掘| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02178|Data Imputation|数据填补| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02179|Data Labels|数据标签| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02180|Data Leakage|数据泄露| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02181|Data Pre-Processing|数据预处理| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02182|Data Processing|数据处理| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02183|Data Quality|数据质量| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02184|Data Reduction|数据缩减| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02185|Data Representation|数据表示| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02186|Data Selection|数据选择| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02187|Data Sources|数据源| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02188|Data Splitting|数据拆分| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02189|Data Transformation|数据转换| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02190|Data-Driven|数据驱动| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02191|Data-Driven Decision-Making|数据驱动的决策| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02192|Data-Driven Methods|数据驱动的方法| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02193|Data-Driven Spectral Analysis|数据驱动的光谱分析| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02194|Data-Mining|数据挖掘| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02195|Database|数据库| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02196|DE Algorithm|差分进化算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02197|Deeplift|DeepLift模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02198|Dendrogram|树状图| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02199|Density Functional Theory|密度泛函理论|DFT|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00512/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)[[4]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[5]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[6]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02200|Density-Based Spatial Clustering Of Applications With Noise|DBSCAN密度聚类|DBSCAN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02201|Descriptor|描述符| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02202|DFT Calculations|DFT计算| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02203|Dice Similarity|戴斯相似度| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02204|Differential Evolution|差分进化|DE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02205|Dimensionality Reduction|降维| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02206|Direct Neural Network Modeling|正向神经网络建模| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02207|Discrete Manner|离散方式| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02208|Discrete Quanta|离散量子| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02209|Discretization|离散化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02210|Distillation|蒸馏| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02211|Dynamic Datasets|动态数据集| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02212|Dynamic Filter Networks|动态过滤网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02213|Dynamic Sampling|动态采样| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02214|Dynamics Simulations|动力学模拟| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02215|Eigenfunction|特征函数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02216|Electronegativity|电负性| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02217|Elman|埃尔曼| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02218|Empirical Models|经验模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02219|Energy Derivatives|能源衍生品| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| 在DP模型中：能量的导数|
AITD-02220|Energy Potentials|能量潜力| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02221|Ensemble Methods|集成方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02222|Entity Normalisation|实体规范化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02223|Ethical Considerations|道德考虑| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02224|Euclidean Distances|欧几里得距离| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00512/978-1-78801-789-3)| |
AITD-02225|Evolutionary Algorithms|进化算法|EA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02226|Evolutionary Method|进化方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02227|Exchange–Correlation|交换关联（的能量/泛函）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02228|Excited-State Potentials|激发态能量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02229|Expected Reduction In Distortion|符合预期的失真减少|ERD|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02230|Experimental Validation Data|实验验证数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02231|Expert Systems|专家系统|ESS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02232|Extended-Connectivity Circular Fingerprint|扩展连接环形指纹|ECFP|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02233|Extraction Techniques|提取技术| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02234|Faber-Christensen-Huang-Lilienfeld|Faber-Christensen-Huang-Lilienfeld|FCHL|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| 四个人提出的化学结构量子机器学习方法|
AITD-02235|Facial Recognition|面部识别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02236|FAIR Data Principles|FAIR数据原则| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| Findability可找寻 Accessibility可访问 Interoperability可交互 Reuse可再用|
AITD-02237|False Negatives|假阴性|FNs|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02238|False Positives|假阳性|FPs|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02239|Fchl Representation|Fchl 表示| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02240|Feature Binarization|特征二值化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02241|Feature Transform|特征变换| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02242|Feature Vectors|特征向量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02243|Features|特征| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02244|Feed Back|反馈| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02245|Feed-Forward Neural Networks|前馈神经网络|FFNN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02246|Feedback Structure|反馈结构| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02247|Final Evaluation|最终评估| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02248|Findable, Accessible, Interoperable, Reusable|可查找、可访问、可互操作、可重用|FAIR|[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02249|First-Principles|第一性原理| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02250|Flow Rate|流速| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02251|Forward Cross-Validation|前向交叉验证| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02252|Forward Prediction|前向预测| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02253|Forward Reaction Prediction|前向反应预测| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02254|Fuzzy Logic|模糊逻辑|FL|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02255|Fuzzy Neural Networks|模糊神经网络|FNN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02256|Ga-Based Approaches|基于遗传算法的方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02257|Garbage In, Garbage Out|无用数据入、无用数据出|GIGO|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02258|Gas-Phase Networks|气相网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)| |
AITD-02259|Gaussian Kernels|高斯核| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02260|Gaussian-Type Structure Descriptors|高斯型结构描述符|GTSD|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)| |
AITD-02261|General Intelligence|通用智能|GI|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02262|Generalized Gradient Approximation|广义梯度近似|GGA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02263|Generative Adversarial Networks|生成对抗网络|GAN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|机器学习|
AITD-02264|Gradient Boosting Decision Tree|梯度提升决策树|GBDT|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02265|Gradient-Based|基于梯度的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02266|Grain-Surface Networks|粒面网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)| |
AITD-02267|Graph Convolutional|图卷积|GC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02268|Graph Models|图模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02269|Graph Neural Networks|图神经网络|GNNS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02270|Graph-Based|基于图形| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02271|Graph-Based Models|基于图的模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02272|Graph-Based Neural Networks|基于图的神经网络| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02273|Graph-Based Representation|基于图的表示|GB-GA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02274|Graph-Convolutional Neural Network|图卷积神经网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02275|Graphics Processing Units|图形处理器| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02276|Gravimetric Polymerization Degree|比重聚合度| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02277|Hamiltonian Matrix|哈密顿矩阵| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|物理|
AITD-02278|Hamiltonian Operator|哈密顿算符| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|物理|
AITD-02279|Heterogeneous Data|异构数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02280|Hidden Layers|隐藏层| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02281|High Data Throughput|高数据吞吐量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02282|High Throughput|高通量|HT|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02283|High Throughput Screening|高通量筛选|HTS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02284|High Variance Models|高方差模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02285|High-Dimensional Data|高维数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02286|High-Dimensional NN|高维神经网络|HDNN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)| |
AITD-02287|High-Dimensional Objects|高维对象| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02288|High-Throughput|高通量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02289|Higher-Dimensional Space|高维空间| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|数学|
AITD-02290|Higher-Dimensional Spectral Space|高维光谱空间| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02291|Homogenization|同质化| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02292|Homomorphic Encryption|同态加密| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02293|Human Face Recognition|人脸识别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|机器学习|
AITD-02294|Human-Encoded|人工编码的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02295|Hybrid Model|混合模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02296|Hybrid Technique|混合技术|HM|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02297|Hybrid-Neural Model|混合神经模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02298|Hyperparameter Opimization|超参数优化| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02299|Hyperparameters|超参数| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)|机器学习|
AITD-02300|Hyperplanes Separate|超平面分离| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02301|Id3 Algorithm|Id3 算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02302|Image And Speech Recognition|图像和语音识别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02303|Image Classification|图像分类| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02304|Image Classifier|图像分类器| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02305|Image Recognition|图像识别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|机器学习|
AITD-02306|Informative Priors|信息先验| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)| |
AITD-02307|Input-Output Pairs|输入输出对| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02308|Instance-Based|基于实例的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02309|Intelligent Machine|智能机器| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02310|Intermediate Neurons|中间神经元| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|机器学习|
AITD-02311|Internet Of Things|物联网|IoT|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02312|Interpolation Coordinate|插值坐标| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02313|Interpretability|可解释性| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02314|Inverse Neural Modeling|逆神经建模|INN|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02315|Inverse Neural Network Modeling|逆神经网络建模| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02316|Iterative Learning|迭代学习| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02317|Joint Distribution|联合分布| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02318|Jordan-Elman Neural Networks|Jordan-Elman 神经网络| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02319|K Clusters|K聚类| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02320|K Nearest Points|K 最近点| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-02321|K-1 Folds|K-1 折| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02322|K-Edge (O-K Edge)|K-边缘（O-K 边缘）| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02323|K-Means|K-均值| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|统计|
AITD-02324|Kendall’S Tau|肯德尔等级相关系数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02325|Kernel Ridge Regression|核岭回归|KRR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02326|Kernels|内核| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02327|Kinetic Curve|动力学曲线| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02328|KNN Model|K 近邻模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02329|Knowledge Extraction|知识提取| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02330|Knowledge Gradient|知识梯度|KG|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02331|L1 And L2 Regularization|L1与L2正则化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02332|Laboratory Level|实验室级别| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02333|Language Processing|语言处理| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02334|Laplacian Prior|拉普拉斯先验| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02335|Large-Scale Data Storage|大规模数据存储| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02336|Lasers|激光器| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02337|Lasso Regression|拉索回归| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02338|LBP|局部二值模式| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02339|Least Absolute Shrinkage And Selection Operator|Lasso回归|LASSO|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02340|Least Square Support Vector Machine|最小二乘支持向量机|LSSVM|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02341|Ligand-Field|配位场| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02342|Linear|线性的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|数学|
AITD-02343|Linear Dimension Reduction Methods|线性降维方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02344|Linear Vibronic Coupling Model|线性振子耦合模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02345|Local Recurrent|本地卷积| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02346|Logic And Heuristics Applied To Synthetic Analysis|LHASA 程序|LHASA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02347|Long-Range Prediction|长期预测| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02348|Long-Range Prediction Models|长期预测模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02349|Long-Term Planning|长期规划| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02350|Long-Term Reward|长期回报| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02351|Machine-Readable Data|机器可读的数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)| |
AITD-02352|Mae|平均绝对误差|MAE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02353|Mahalanobis Distances|马氏距离| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-02354|Matrices|矩阵| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|数学|
AITD-02355|Matthews Correlation Coefficient|马修斯相关系数|MCC|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02356|Maximum Likelihood Methods|最大似然法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|统计|
AITD-02357|Maximum Likelihood Procedures|最大似然估计法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-02358|MCTS Method|蒙特卡洛树搜索方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02359|Mean-Squared Error|均方误差| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|统计、机器学习|
AITD-02360|Mechanical Sympathy|机械同感，软硬件协同编程| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02361|Merging|合并| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02362|Message Passing Neural Networks|消息传递神经网络|MPNNS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02363|Microarray Data|微阵列数据| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02364|Mini Batch|小批次| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02365|Mining|挖掘| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02366|Mining Out|挖掘| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02367|Missing Values|缺失值| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)|统计|
AITD-02368|ML Algorithm|机器学习算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02369|ML Modelling|机器学习建模| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00206/978-1-83916-023-3)| |
AITD-02370|ML Potentials|机器学习势能| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02371|ML-Driven|机器学习驱动的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02372|ML-Driven Optimization|机器学习驱动的最优化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02373|MLP Neural Model|多层感知机神经模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02374|Model Construction|模型构建| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02375|Model Evaluation|模型评估| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02376|Model Performance|模型性能| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02377|Model Statistics|模型统计| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02378|Model Training|模型训练| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02379|Model Validation|模型验证| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02380|Model-Based Iterative Reconstruction|基于模型的迭代重建|MBIR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00450/978-1-78801-789-3)| |
AITD-02381|Model-Construction|模型构建| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02382|Modelling Scenario|建模场景| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02383|Molecular Graph Theory|分子图论| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02384|Molecular Modelling|分子建模| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)| |
AITD-02385|Monte Carlo Tree Search|蒙特卡洛树搜索|MCTS|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)[[3]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)|数学|
AITD-02386|Moore’S Law|摩尔定律| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00512/978-1-78801-789-3)|计算机|
AITD-02387|ms-QSBER-EL Model|基于人工神经网络组合的结构生物学效应定量关系多尺度模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)| |
AITD-02388|Multi-Agent Control System|多智能体控制系统| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02389|Multi-Core Desktop Computer|多核台式计算机| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|计算机|
AITD-02390|Multi-Dimensional Big Data Analysis|多维度大数据分析| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00424/978-1-78801-789-3)| |
AITD-02391|Multi-Layer Feed-Forward|多层前馈|MLFF|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)| |
AITD-02392|Multi-Objective Genetic Algorithm|多目标遗传算法|MOGA|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02393|Multi-Objective Optimization|多目标优化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)|机器学习|
AITD-02394|Multi-Reaction Synthesis|多反应合成| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02395|Multilayer Perceptron|多层感知机| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00227/978-1-78801-789-3)| |
AITD-02396|Multivariate Regression|多变量回归| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02397|N-Dimensional Space|N维空间| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00372/978-1-78801-789-3)| |
AITD-02398|Naive Bayesian|朴素贝叶斯| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|统计|
AITD-02399|Naive Bayesian Methods|朴素贝叶斯方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|统计|
AITD-02400|Named Entity Recognition，NER|命名实体识别|NER|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00280/978-1-78801-789-3)| |
AITD-02401|Nearest Neighbors|近邻| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02402|Nearest Neighbour Model|近邻模型| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02403|Negative Predictive Value|阴性预测值|NPV|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02404|Network Architecture|网络结构| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|机器学习|
AITD-02405|Network Geometry|网络几何| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02406|Neural Turing Machines|神经图灵机|NTM|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02407|Neural-Network-Based Function|基于神经网络的函数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)| |
AITD-02408|Neurons|神经元| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02409|Nuclear Magnetic Resonance|核磁共振|NMR|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)| |
AITD-02410|Noise Filters|噪声过滤器| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02411|Noise-Free|无噪的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02412|Non-Linear|非线性| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|数学、统计|
AITD-02413|Non-Linear Correlation|非线性相关| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00195/978-1-83916-023-3)|统计|
AITD-02414|Non-Linearity|非线性| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)| |
AITD-02415|Non-Parametric Algorithm|非参数化学习算法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00311/978-1-78801-789-3)| |
AITD-02416|Non-Safety-Critical Applications|非安全关键型应用| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)| |
AITD-02417|Non-Steady-State|非稳态| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)| |
AITD-02418|Non-Stochastic|非随机的| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00398/978-1-78801-789-3)| |
AITD-02419|Non-Template|非模板| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02420|Non-Template Methods|非模板方法| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)| |
AITD-02421|Non-Zero Weight|非零权重| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)| |
AITD-02422|On-The-Fly Optimization|运行中优化| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|计算机|
AITD-02423|One-Hot Vector|独热向量| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00136/978-1-78801-789-3)|整个矢量中之后一个数为1 其余为0|
AITD-02424|Open-Source|开源| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|软件工程|
AITD-02425|Open-Source Dataset|开源数据集| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00169/978-1-78801-789-3)|机器学习|
AITD-02426|Predicted Label|预测值| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02427|Prediction|预测| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02428|Prediction Accuracy|预测准确率| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|机器学习|
AITD-02429|Predictor|预测器/决策函数| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00251/978-1-78801-789-3)|机器学习|
AITD-02430|Protein Folding|蛋白折叠| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)[[2]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|生物|
AITD-02431|Quantum Chemistry|量子化学| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00076/978-1-78801-789-3)|化学|
AITD-02432|Quantum Theory|量子理论| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|物理|
AITD-02433|Random Selection|随机选择| |[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00037/978-1-78801-789-3)|统计|
AITD-02434|Raw Datasets|原始数据集| |[[1]](https://www.nature.com/articles/s41557-021-00716-z)|机器学习|
AITD-02435|Root Mean Square Errors|均方根|RMSE|[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00488/978-1-78801-789-3)|统计|
AITD-02436|Scaling|缩放||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00109/978-1-78801-789-3)|图像处理|
AITD-02437|Simulation|仿真||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00340/978-1-78801-789-3)||
AITD-02438|The Global Minimum|全局最小值||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00016/978-1-78801-789-3)|机器学习|
AITD-02439|Turing Test|图灵测试||[[1]](https://pubs.rsc.org/en/content/chapter/bk9781788017893-00001/978-1-78801-789-3)|AI，CS|
AITD-02440|Version Control|版本控制||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-02441|Workflow|工作流||[[1]](https://www.nature.com/articles/s41557-021-00716-z)||
AITD-02442|Sequence-Function|序列-功能||[1]||
